<?php

use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::middleware(['auth'])->group(function () {

    Route::get('/', function () {
        return Inertia::render('HomePage');
    });

    Route::get('/information', function () {
        return Inertia::render('Informations');
    });

    Route::get('/links', function () {
        return Inertia::render('LinkPage');
    });
});

Route::get('/login', function () {
    return Inertia::render('Auth/Login');
})->name('login');

Route::post('/login', [UserController::class, 'login']);

Route::post('/logout', [UserController::class, 'logout'])
    ->middleware('auth')
    ->name('logout');
